****************************************************************************
***
*** ASECTION.PRG - Funcin que obtiene una seccin de un fichero .INI y la
***                situa en una matriz
***
*** Parametros : 1. Seccin (carcter)
***              2. Nombre del arrray (carcter)
***              3. Fichero .INI (carcter)
***
***        Pablo Almunia Sanz
***        100341.1136@compuserve.com
***
****************************************************************************
****************************************************************************
*** Este programa es de libre distibucin. El autor no se compromente a
*** a ningn tipo de soporte sobre el cdigo o su uso. El autor no es
*** responsable del uso que se pueda hacer del cdigo, de los errores que
*** pueda contener o de la perdida o destruccin de datos que puedan ser
*** causados por el mismo.
****************************************************************************

PROCEDURE GtIniSec
LPARAMETER cSeccion, cArray, cNombreFich

*** Tamao del buffer (puede cambiarse) ***
#define MAX_SECTION 5120

*** Todas la variables locales ***
LOCAL cBuffer, cTmp
LOCAL nResult, nCont
LOCAL nInicioLinea, nFinLinea, nPosIgual

*** Cargar las declaraciones ***
DO profiles

*** Preparar bufferr ***
cBuffer = REPLICATE( CHR(0), MAX_SECTION )

*** Obtener todo la seccin ***
nResult = GetPrivateProfileSection( ;
            cSeccion, ;
            @cBuffer, ;
            MAX_SECTION, ;
            cNombreFich )

*** Comprobar si existen errores ***
IF nResult == 0
  RETURN 0
ENDIF

*** Inicializar variables ***
nInicioLinea = 1
nFinLinea = 1
nCont = 0
cTmp = ""

*** Procesar el resultado ***
DO WHILE nFinLinea < nResult

  *** Aumentar el contador de nulos ***
  nCont = nCont + 1

  *** Posicin del prximo nulo ***
  nFinLinea = AT( CHR(0), cBuffer, nCont )

  *** Cadena de una lnea ***
  cTmp = SUBSTR( cBuffer, ;
                 nInicioLinea, ;
                 nFinLinea - nInicioLinea )

  *** Redimensionar el array ***
  PUBLIC ARRAY &cArray.[nCont,2]

  *** Posicin del igual ***
  nPosIgual = AT( '=', cTmp )

  *** Cargar la clave ***
  &cArray.[nCont,1] = ;
    SUBSTR( cTmp, 1, nPosIgual - 1 )

  *** Cargar el valor si existe ***
  IF nPosIgual < LEN( cTmp )
          &cArray.[nCont,2] = ;
            SUBSTR( cTmp, nPosIgual + 1 )
  ELSE
      &cArray.[nCont,2] = ""
  ENDIF

  *** El incio de la siguiente lnea ***
  *** es el fin de esta ***
  nInicioLinea = nFinLinea + 1

ENDDO

*** Retornar el nmero de lneas encontradas ***
RETURN nCont


*** Fin de ASECTION.PRG ***